// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ camera.cpp ]		Auter : KENSUKE WATANABE
//										Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
// -------- -------- -------- -------- -------- -------- -------- --------
// CN[ht@C
// -------- -------- -------- -------- -------- -------- -------- --------
#include "main.h"
#include <algorithm>
#include <assert.h>
#include "camera.h"
#include "Wwise.h"
#include "debugStr.h"
#include "inputKeyboard.h"
#include "inputMouse.h"
#include "renderer.h"
#include "manager.h"
#include "scene.h"
#include "player.h"
#include "sceneField.h"
#include "car.h"

static const D3DXVECTOR3 CAM_LEN = D3DXVECTOR3(0.f, 2.f, -5.f);		// JW - ze[vʂɐݒ肵悤
static const float CAM_MOVE_SPEED = 1.f;

// ======== ======== ======== ======== ======== ======== ======== ========
// RXgN^
// -------- -------- -------- -------- -------- -------- -------- --------
CCamera::CCamera()
{
	m_len = 0.f;
	m_rot = D3DXVECTOR3(0.f, 0.f, 0.f);			// ]
	m_posCamera = D3DXVECTOR3(0.f, 0.f, 0.f);	// W
	m_posAt = D3DXVECTOR3(0.f, 0.f, 0.f);		// _
	m_vecUp = D3DXVECTOR3(0.f, 0.f, 0.f);		// J̏
	D3DXMatrixIdentity(&m_mtxView);				// r[W
	m_pField = nullptr;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CCamera::Init(void)
{
	m_atObjType = AT_OBJTYPE::NONE;
	m_rot = D3DXVECTOR3(0.f, 0.f, 0.f);		// ]
	m_posCamera = CAM_LEN;					// W
	m_pField = nullptr;

	// _W̐ݒ
	for (int n = 0; n < MAX_SCENE_PRIORITY; n++)
	{
		std::list<CScene*> *lisScene = CScene::GetScene(n);
		for (CScene* pScene : *lisScene)
		{
			if (pScene == nullptr)continue;
			// ^Cv̎擾
			CScene::OBJTYPE objType = pScene->GetObjType();

			if (objType == CScene::OBJTYPE::FIELD)
			{
				// _ELXg
				m_pField = ((CSceneField*)pScene);
				continue;
			}
		}
	}
	// J̋̑
	D3DXVECTOR3 vec3 = D3DXVECTOR3(m_posAt.x - m_posCamera.x, 0.f, m_posAt.z - m_posCamera.z);
	m_len = sqrt(vec3.x * vec3.x + vec3.z * vec3.z);

	m_vecUp = D3DXVECTOR3(0.f, 1.f, 0.f);			// J̏

#ifdef _DEBUG
	// fobO\ptHg̐
	std::vector<float> vecPosCamera;
	vecPosCamera.push_back(m_posCamera.x);
	vecPosCamera.push_back(m_posCamera.y);
	vecPosCamera.push_back(m_posCamera.z);
	CDebugStr::Create(2, "CAMERA_POS", vecPosCamera);
#endif
}

// ======== ======== ======== ======== ======== ======== ======== ========
// I
// -------- -------- -------- -------- -------- -------- -------- --------
void CCamera::Uninit(void)
{

}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CCamera::Update(void)
{
	// _W̐ݒ
	D3DXVECTOR3 rotObj = D3DXVECTOR3(0.f, 0.f, 0.f);
	D3DXVECTOR3 lookAt = D3DXVECTOR3(0.f, 0.f, 0.f);

	if (m_atObjType == AT_OBJTYPE::CONTROL_PLAYER)
	{
		std::string name = CMainController::GetName();
		if (name.empty())return;
		CCar *pCar = CCar::GetCar(name);
		rotObj = pCar->GetRot();
		lookAt = pCar->GetCamPosAt();
	}

	float lenAt = m_len;

	//======================================
	// J͏ɃvC[̓̌
	//--------------------------------------
	SetLockAt(lookAt);
	m_posCamera = lookAt - D3DXVECTOR3(cosf(rotObj.y * -1.f + D3DX_PI * 0.5f + m_rot.y) * CAM_LEN.z, CAM_LEN.y * -1.f, sinf(rotObj.y * -1.f + D3DX_PI * 0.5f + m_rot.y) * CAM_LEN.z);
//	D3DXVECTOR3 camToAtVec = lookAt - m_posCamera;
//	lookAt.x += camToAtVec.x * 0.5f;
//	lookAt.z += camToAtVec.z * 0.5f;
	m_rot.y = (0.f - m_rot.y) * 0.98f;

	m_len = lenAt;

#ifdef _DEBUG
	// fobO\ptHg̍XV
	std::vector<float> vecPosCamera;
	vecPosCamera.push_back(m_posCamera.x);
	vecPosCamera.push_back(m_posCamera.y);
	vecPosCamera.push_back(m_posCamera.z);
	CDebugStr::Set("CAMERA_POS", vecPosCamera);
#endif
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ]
// -------- -------- -------- -------- -------- -------- -------- --------
void CCamera::AddCamRoate(const float &rot )
{
	// Y
	m_rot.y += rot;
	m_posCamera.x = m_len * cosf(m_rot.y) + m_posAt.x;
	m_posCamera.z = m_len * sinf(m_rot.y) + m_posAt.z;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// _ݒ
// -------- -------- -------- -------- -------- -------- -------- --------
void CCamera::SetLockAt(D3DXVECTOR3 lookAt)
{
	lookAt.y += CAM_LEN.y;
	m_posAt = lookAt;
}

// ======== ======== ======== ======== ======== ======== ======== ========
// Jݒ
// -------- -------- -------- -------- -------- -------- -------- --------
void CCamera::Set(void)
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	D3DXMatrixLookAtLH(&m_mtxView, &m_posCamera, &m_posAt, &m_vecUp);	// r[ϊs

	// foCXɃr[ϊsݒ
	pDevice->SetTransform(D3DTS_VIEW, &m_mtxView);

	D3DXVECTOR2 screenSize = CManager::GetRenderer().GetScreenSize();

	// vWFNVs̍쐬
	D3DXMatrixPerspectiveFovLH(&m_mtxProj,		// vWFNVs̃AhX
		D3DX_PI / 4.f,							// p
		(float)screenSize.x / screenSize.y,		// AXyNg (XN[̃TCYŊ)
		CAM_NEAR,								// near
		CAM_FAR);								// far

	// foCXɃvWFNVϊsݒ
	pDevice->SetTransform(D3DTS_PROJECTION, &m_mtxProj);
}

// ======== ======== ======== ======== ======== ======== ======== ========
// XN[W[hWɕϊ
// -------- -------- -------- -------- -------- -------- -------- --------
D3DXVECTOR3* CCamera::CalcScreenToWorld(
	D3DXVECTOR3* pout,	// o
	int Sx,				// XN[XW
	int Sy,				// XN[YW
	float fZ,			// ˉeԂłZli0`1j
	int Screen_w,		// XN[
	int Screen_h,		// XN[
	const D3DXMATRIX &View,	// r[s
	const D3DXMATRIX &Prj)	// vWFNVs
{
	// es̋tsZo
	D3DXMATRIX InvView, InvPrj, VP, InvViewport;
	D3DXMatrixInverse(&InvView, nullptr, &View);
	D3DXMatrixInverse(&InvPrj, nullptr, &Prj);
	D3DXMatrixIdentity(&VP);
	VP._11 = Screen_w / 2.f;
	VP._22 = -Screen_h / 2.f;
	VP._41 = Screen_w / 2.f;
	VP._42 = Screen_h / 2.f;
	D3DXMatrixInverse(&InvViewport, nullptr, &VP);

	// tϊ
	D3DXMATRIX tmp = InvViewport * InvPrj * InvView;
	D3DXVECTOR3 VecS = D3DXVECTOR3(static_cast<float>(Sx), static_cast<float>(Sy), static_cast<float>(fZ));
	D3DXVec3TransformCoord(pout, &VecS, &tmp);

	return pout;
}